program define m_BAR
	version 9.1
	quietly set more off
	
/// NORMALIZING THE VALUE OF THE TREATMENT SAMPLES ///
	
local n1 = $n1
local n2 = $n2	
local name1 "$name1"
local name2 "$name2"

	forvalues i = 1(1)2 {
		matrix norm_treatment`i' = J(`n`i'',1,.)
		
		forvalues j = 1(1)`n`i'' {
			matrix norm_treatment`i'[`j',1]=(`name`i''[`j',1]-$low_int)/($up_int-$low_int)
		}
		
	}

/// DROPPING THE OBSERVATIONS FROM THE SAMPLE (OUTER LOOP) ///	
	
if (`n1' == `n2') local montecarlo_drops = 10^0
else if (`n1' > `n2') local montecarlo_drops = 10^($accuracy/2)
	
matrix res_drops = J(`montecarlo_drops',1,.)	/// This matrix stores the results from the outer loop ///
	
display as txt "{hline}"
display as txt "{hilite}Computing"
display as txt "{hline}"
display as res "Each point corresponds to one iteration of the outer loop"
display as res "With this set of parameters, the computation requires {hilite:`montecarlo_drops' iterations}"
display _newline(1)
	
	forvalues drop = 1(1)`montecarlo_drops' {
		
		matrix x = norm_treatment1
		
			if (`n1' > `n2') {
				
				local diff = `n1' - `n2'
				
				forvalues i = 1(1)`diff' {
					matrix which = matuniform(1,1)
					matrix which[1,1] = ceil(which[1,1]*(`n1'-`i'+1))
					
					if (which[1,1] == 1) {
						matrix x = x[2...,1]
					}
					else if (which[1,1] == (`n1'-`i'+1)) {
						matrix x = x[1..(`n1'-`i'),1]
					}
					else {
						matrix x = x[1..which[1,1]-1,1] \ x[which[1,1]+1...,1]
					}
				}
			}
			
		local n = `n2'
		matrix y = norm_treatment2
		
	 /// COMPUTING THE BEST TREATMENT ///
		
		local montecarlo_shots = 10^($accuracy/2)
		local result = 0
		
		matrix res_shots = J(`montecarlo_shots',1,.)	/// This matrix stores the results from the inner loop ///
		
		forvalues shot = 1(1)`montecarlo_shots' {	
			
			matrix flipping_coin = matuniform(`n',2)
			gen binary_x = 0
			gen binary_y = 0
			
			forvalues i = 1(1)`n' {
				if (x[`i',1] > flipping_coin[`i',1]) {
				quietly replace binary_x = 1 in `i'
				}
				else {
				}
				if (y[`i',1] > flipping_coin[`i',2]) {
				quietly replace binary_y = 1 in `i'
				}
				else {
				}
			}
			
			egen sum_x = sum(binary_x)
			matrix sum_x = sum_x[1]
			egen sum_y = sum(binary_y)
			matrix sum_y = sum_y[1]
			
			if (sum_x[1,1] > sum_y[1,1]) {
			local result = `result' + (1 / `montecarlo_shots')
			}
			else if (sum_x[1,1] < sum_y[1,1]) {
			}
			else {
			local result = `result' + (.5 / `montecarlo_shots')
			}
			
			matrix res_shots[`shot',1] = `result'
			drop binary**
			drop sum**
			
		} /// ENDING INNER LOOP ///
		
		matrix res_drops[`drop',1] = res_shots[`montecarlo_shots',1]
		use temp2, clear
		noi di as txt "." _continue
		
		local end = `montecarlo_drops'/25
		forvalues i = 1(1)`end' {
			if (`drop'==`i'*25) {
				disp "`drop'"
			}			
		}
		
	} /// ENDING OUTER LOOP ///
	
	quietly svmat res_drops
	generate prob_treat1 = sum(res_drops1) / `montecarlo_drops'
	matrix prob_treat1 = prob_treat1[_N]

display _newline(1)
display as txt "{hline}"
display as txt _col(50) "{hilite}RESULTS"
display as txt "{hline}"
display _newline(1)
display as txt "{hline}"
display as txt "{hilite}PARAMETERS"
display as txt "{hline}"
display as txt "Regret: " as res _col(17) regret[1,1] /*
*/as txt _col(70) "Cost for Treatment1:" as res _col(80) " $cost1"
display _newline(1)
display as txt "Method:" as res _col(17)" Binomial Average Rule" /*
*/as txt _col(70) "Cost for Treatment2:" as res _col(80) " $cost2"
display _newline(1)
display as txt "Paired sample:" as res _col(17) " No"
display _newline(1)
display as txt "Range of values:" as res _col(17) "[$low ; $up]"

local prob_treat1 = prob_treat1[1,1]
local prob_treat2 = 1 - prob_treat1[1,1]

display _newline(1)
display as txt "{hline}"
display as txt "{hilite}RECOMMENDATION"
display as txt "{hline}"
display _newline(1)
display as txt "Probability of choosing {hilite:Treatment 1}:" as res " 0"`prob_treat1'
display _newline(1)	
display as txt "Probability of choosing {hilite:Treatment 2}:" as res " 0"`prob_treat2'
	
end
